const webApiUrl = "https://forfettappapi-core.azurewebsites.net" // Produzione
const debug = false;

window.ForfettApp = $.extend(true, window.ForfettApp, {
  config: {
    appVersion: "1.9.6",
    webApiCoreUrl: webApiUrl,

    freshServiceUrl: null,
    stripeUrl: null,

    forceConsoleLog: debug,
    forceRemoteLog: false,

    biometricAvailable: true,
    biometricEnabled: false,

    debug: debug,

    layoutSet: "slideout",
    animationSet: "native",
    navigation: [
      {
        id: "SITUAZIONE",
        title: "Situazione",
        onExecute: "#dashboard",
        icon: "material-icons mi-situazione",
        visible: true,
      },
      {
        id: "CLIENTI",
        title: "I miei clienti",
        onExecute: "#elencoClienti",
        icon: "material-icons mi-clienti",
        visible: false,
      },
      {
        id: "PREVENTIVI",
        title: "Preventivi",
        onExecute: "#elencoPreventivi",
        icon: "material-icons mi-preventivi",
        visible: false,
      },
      {
        id: "DOCUMENTI_ATTIVI",
        title: "Le mie fatture",
        onExecute: "#elencoDocumentiAttivi",
        icon: "material-icons mi-fatture-attive",
        visible: false,
      },
      {
        id: "DOCUMENTI_PASSIVI",
        title: "Fatture ricevute",
        onExecute: "#documentiPassivi",
        icon: "material-icons mi-documenti-passivi",
        visible: false,
      },
      {
        id: "INCASSI",
        title: "I miei incassi",
        onExecute: "#elencoIncassiPagamenti",
        icon: "material-icons mi-incassi-pagamenti",
        visible: false,
      },
      {
        id: "CORRISPETTIVI",
        title: "Corrispettivi",
        onExecute: "#elencoCorrispettivi",
        icon: "material-icons mi-corrispettivi",
        visible: false,
      },
      {
        id: "DOCUMENTI_UTENTI",
        title: "Documenti",
        onExecute: "#elencoDocumentiUtenti",
        icon: "material-icons mi-documenti",
        visible: false,
      },
      {
        id: "PAGAMENTI_F24",
        title: "Pagamenti F24",
        onExecute: "#elencoPagamentiF24",
        icon: "material-icons mi-cassetto-fiscale",
        visible: false,
      },
      {
        id: "DICHIARAZIONI",
        title: "Dichiarazioni dei redditi",
        onExecute: "#elencoDichiarazioni",
        icon: "material-icons mi-dichiarazioni",
        visible: false,
      },
      {
        id: "STUDIO_INPS",
        title: "Gestione INPS",
        onExecute: "#gestioneInps",
        icon: "material-icons mi-elderly",
        visible: false,
      },
      {
        id: "IMPOSTAZIONI",
        title: "Impostazioni",
        onExecute: "#impostazioni",
        icon: "material-icons mi-impostazioni",
        visible: true,
      },
    ],

    commandMapping: {
      "ios-header-toolbar": {
        defaults: {
          showIcon: "true",
          showText: "false",
          align: "left",
        },
        commands: [
          "registerButton",
          "search",
          "map",
          "nuovo",
          {
            id: "cambiaAnno",
            location: "after",
            icon: "material-icons mi-calendar-month",
          },
          {
            id: "add-ios",
            location: "after",
            icon: "add",
          },
          {
            id: "delete",
            location: "after",
            icon: "material-icons mi-delete",
          },
          {
            id: "find",
            location: "after",
            icon: "find",
          },
          {
            id: "menu-add",
            location: "menu",
          },
          {
            id: "menu-edit",
            locateInMenu: "always",
          },
          {
            id: "menu-remove",
            locateInMenu: "always",
          },
          {
            id: "menu-nota",
            locateInMenu: "always",
          },
          {
            id: "menu-allegato",
            locateInMenu: "always",
            icon: "material-icons mi-atttach_file",
          },
          {
            id: "menu-convenzione",
            locateInMenu: "always",
          },
          {
            id: "menu-impostazioni",
            locateInMenu: "always",
          },
          {
            id: "menu-anteprima",
            locateInMenu: "always",
          },
          {
            id: "menu-crea-nota-credito",
            locateInMenu: "always",
          },
          {
            id: "command-notifiche",
            location: "after",
            icon: "material-icons mi-notifications",
          },
          {
            id: "command-criticita",
            location: "after",
          },
          {
            id: "help",
            location: "after",
            icon: "material-icons mi-help",
          },
          {
            id: "close",
            location: "after",
            icon: "material-icons mi-close",
          },
          {
            id: "file-download",
            location: "after",
            icon: "material-icons mi-file-download",
          },
          {
            id: "preferito-on",
            location: "after",
            icon: "material-icons mi-star",
          },
          {
            id: "preferito-off",
            location: "after",
            icon: "material-icons mi-star-border",
          },
          {
            id: "visibility-on",
            location: "after",
            icon: "material-icons mi-visibility-on",
          },
          {
            id: "visibility-off",
            location: "after",
            icon: "material-icons mi-visibility-off",
          },
          {
            id: "settings",
            location: "after",
            icon: "material-icons mi-settings",
          },
        ],
      },

      "android-header-toolbar": {
        defaults: {
          showIcon: "true",
          showText: "true",
          align: "right",
        },
        commands: [
          "search",
          "map",
          {
            id: "cambiaAnno",
            location: "after",
            icon: "material-icons mi-calendar-month",
          },
          {
            id: "add",
            location: "after",
            icon: "add",
          },
          {
            id: "edit",
            location: "after",
            icon: "edit",
          },
          {
            id: "delete",
            location: "after",
            icon: "material-icons mi-delete",
          },
          {
            id: "overflowMenu",
            location: "after",
            icon: "overflow",
          },
          {
            id: "save",
            location: "after",
            icon: "save",
          },
          {
            id: "find",
            location: "after",
            icon: "find",
          },
          {
            id: "help",
            location: "after",
            icon: "material-icons mi-help",
          },
          {
            id: "menu-add",
            location: "menu",
          },
          {
            id: "menu-edit",
            locateInMenu: "always",
          },
          {
            id: "menu-remove",
            locateInMenu: "always",
          },
          {
            id: "menu-nota",
            locateInMenu: "always",
          },
          {
            id: "menu-convenzione",
            locateInMenu: "always",
          },
          {
            id: "menu-allegato",
            locateInMenu: "always",
            icon: "material-icons mi-atttach_file",
          },
          {
            id: "menu-impostazioni",
            locateInMenu: "always",
          },
          {
            id: "menu-anteprima",
            locateInMenu: "always",
          },
          {
            id: "menu-crea-nota-credito",
            locateInMenu: "always",
          },
          {
            id: "command-notifiche",
            location: "after",
            icon: "material-icons mi-notifications",
          },
          {
            id: "command-criticita",
            location: "after",
          },
          {
            id: "close",
            location: "after",
            icon: "material-icons mi-close",
          },
          {
            id: "file-download",
            location: "after",
            icon: "material-icons mi-file-download",
          },
          {
            id: "preferito-on",
            location: "after",
            icon: "material-icons mi-star",
          },
          {
            id: "preferito-off",
            location: "after",
            icon: "material-icons mi-star-border",
          },
          {
            id: "visibility-on",
            location: "after",
            icon: "material-icons mi-visibility-on",
          },
          {
            id: "visibility-off",
            location: "after",
            icon: "material-icons mi-visibility-off",
          },
          {
            id: "settings",
            location: "after",
            icon: "material-icons mi-settings",
          },
        ],
      },

      "generic-header-toolbar": {
        defaults: {
          showIcon: "true",
          showText: "false",
          align: "left",
        },
        commands: [
          "registerButton",
          "search",
          "map",
          "nuovo",
          {
            id: "cambiaAnno",
            location: "after",
            icon: "fa fa-calendar",
          },
          {
            id: "add-ios",
            location: "after",
            icon: "add",
          },
          {
            id: "delete",
            location: "after",
            icon: "material-icons mi-help",
          },
          {
            id: "find",
            location: "after",
            icon: "find",
          },
          {
            id: "help",
            location: "after",
            icon: "material-icons mi-help",
          },
          {
            id: "menu-add",
            location: "menu",
          },
          {
            id: "menu-edit",
            locateInMenu: "always",
          },
          {
            id: "menu-remove",
            locateInMenu: "always",
          },
          {
            id: "menu-nota",
            locateInMenu: "always",
          },
          {
            id: "menu-allegato",
            locateInMenu: "always",
            icon: "material-icons mi-atttach_file",
          },
          {
            id: "menu-impostazioni",
            locateInMenu: "always",
          },
          {
            id: "menu-anteprima",
            locateInMenu: "always",
          },
          {
            id: "menu-crea-nota-credito",
            locateInMenu: "always",
          },
        ],
      },
    },
  },
});
